#include "hector.h"

#include <util/string/escape.h>
#include <util/string/vector.h>

#include <library/cpp/json/json_writer.h>
#include <library/cpp/json/writer/json.h>

namespace NSecretSearch {
    namespace NOutput {
        /*
[
  {
    "path": "/home/buglloc/work/projects/ant-secret-test/tokens/settings.py",
    "line_no": 1,
    "problem": {
      "plugin": "Tokens",
      "message": "YT_TOKEN = 'AQAD-XXXX'",
      "secret": "AQAD-XXXX",
      "type": "YandexOauth",
      "validated": false,
      "additional": {
        "sha1": "ed512fd005a82dc897a907d707366a76df5143a7"
      }
    }
  }
]
*/

        THector::THector(IOutputStream& out)
            : TBase(out)
            , jsonWriter(&out, /*formatOutput*/ false, /*sortkeys*/ false, /*validateUtf8*/ false)
        {
        }

        void THector::Start() {
            jsonWriter.OpenArray();
        }

        void THector::Finish() {
            jsonWriter.CloseArray();
            jsonWriter.Flush();
        }

        void THector::Write(const TPathResult& result) {
            for (const auto& secret : result.SearcherResults) {
                jsonWriter.OpenMap();
                jsonWriter.Write("path", result.Path);
                jsonWriter.Write("line_no", secret.LineNo);
                jsonWriter.OpenMap("problem");
                if (!secret.SourceLine.empty()) {
                    jsonWriter.Write("source_line", secret.SourceLine);
                }

                if (secret.Secret) {
                    jsonWriter.Write("secret", secret.Secret);
                }
                jsonWriter.Write("type", secret.Type);
                jsonWriter.Write("validated", secret.Validated);
                jsonWriter.Write("ignore", secret.Ignore);
                if (!secret.Additional.empty()) {
                    jsonWriter.OpenMap("additional");
                    for (const auto& item : secret.Additional) {
                        if (!item.second.empty()) {
                            jsonWriter.Write(item.first, item.second);
                        }
                    }
                    jsonWriter.CloseMap();
                }
                jsonWriter.CloseMap();
                jsonWriter.CloseMap();
            }
        }

    }
}
