#include "json.h"

#include <util/string/escape.h>
#include <util/string/vector.h>

#include <library/cpp/json/json_writer.h>
#include <library/cpp/json/writer/json.h>

namespace NSecretSearch {
    namespace NOutput {
        TJson::TJson(IOutputStream& out)
            : TBase(out)
            , jsonWriter(&out, /*formatOutput*/ false, /*sortkeys*/ false, /*validateUtf8*/ false)
        {
        }

        void TJson::Start() {
            jsonWriter.OpenArray();
        }

        void TJson::Finish() {
            jsonWriter.CloseArray();
            jsonWriter.Flush();
        }

        void TJson::Write(const TPathResult& result) {
            result.ToJson(jsonWriter);
        }

    }
}
