#include "proto.h"

namespace NSecretSearch {
    namespace NOutput {
        TProto::TProto(IOutputStream& out)
                : TBase(out)
        {
        }

        void TProto::Write(const TPathResult& result) {
            auto issue = proto.add_issues();
            issue->set_path(result.Path);
            for (auto&& searchResult : result.SearcherResults) {
                auto secret = issue->add_secrets();
                secret->set_type(searchResult.Type);
                secret->set_secret(searchResult.Secret);
                secret->set_sourceline(searchResult.SourceLine);
                secret->set_line_no(searchResult.LineNo);
                secret->set_ignored(searchResult.Ignore);
                secret->set_validated(searchResult.Validated);
                auto& additional = *secret->mutable_additional();
                for (auto&& [key, val] : searchResult.Additional) {
                    additional[key] = val;
                }
            }
        };

        void TProto::Start() {
            proto.Clear();
        };

        void TProto::Finish() {
            proto.SerializeToArcadiaStream(&out);
        };

    }
}
