#include "startrek.h"

#include <util/string/vector.h>
#include <util/string/subst.h>

namespace NSecretSearch {
    namespace NOutput {
        namespace {
            void writeAdditionalInfo(TSecretAdditional additionalInfo, IOutputStream& out) {
                TVector<TStringBuf> keys;
                Transform(additionalInfo.begin(), additionalInfo.end(), std::back_inserter(keys),
                          [](auto const& pair) {
                              return pair.first;
                          });
                Sort(keys);

                for (const auto& key : keys) {
                    if (key == "sha1" || key == "secret" || additionalInfo[key].empty()) {
                        continue;
                    }

                    out << "    * " << key << ": %%" << additionalInfo[key] << "%%" << Endl;
                }
            }

            void writeHeader(IOutputStream& out) {
                out
                    << "Найдены секретные ключи/пароли/токены." << Endl
                    << "Их необходимо перевыпустить и хранить в ((https://wiki.yandex-team.ru/security/secrets/ надлежащем месте))."
                    << Endl;
            }

        }

        void TStartrek::Write(const TPathResult& result) {
            if (!headerWrited) {
                headerWrited = true;
                writeHeader(out);
            }

            out << "((" << result.Path << " " << result.Path << ")):" << Endl;
            for (const auto& secret : result.SearcherResults) {
                if (!secret.SourceLine.empty()) {
                    auto message = secret.SourceLine;
                    SubstGlobal(message, "%%", "~%%");
                    out << "  - line [" << secret.LineNo << "]: %%" << message << "%%" << Endl;
                } else {
                    out << "  - line: " << secret.LineNo << Endl;
                }

                if (!secret.Secret.empty()) {
                    out << "  - secret: **%%" << secret.Secret << "%%**" << Endl;
                }

                if (secret.Additional.size() > 2) {
                    out << "  - additional:" << Endl;
                    writeAdditionalInfo(secret.Additional, out);
                }

                out << Endl;
            }
        }

    }
}
