#include "text.h"

#include <util/string/escape.h>
#include <util/string/join.h>

namespace NSecretSearch {
    namespace NOutput {
        namespace {
            TString constructAdditionalInfo(const TSecretAdditional& additionalInfo) {
                TVector<TString> result;
                for (const auto& additional : additionalInfo) {
                    if (additional.second.empty()) {
                        continue;
                    }

                    if (additional.second.Contains(' ')) {
                        result.push_back(additional.first + ":" + EscapeC(additional.second));
                    } else {
                        result.push_back(additional.first + ":" + additional.second);
                    }
                }

                return JoinSeq(" ", result);
            }

        }

        void TText::Write(const TPathResult& result) {
            for (const auto& secret : result.SearcherResults) {
                auto secretStr = secret.Secret;
                if (secretStr.empty() && !secret.SourceLine.empty()) {
                    secretStr = secret.SourceLine;
                }

                if (!secret.Additional.empty()) {
                    out
                        << result.Path << ":" << secret.LineNo
                        << " (" << secret.Type << ")"
                        << " [" << constructAdditionalInfo(secret.Additional) << "]"
                        << (!secretStr.empty() ? ": " + secretStr : "")
                        << Endl;
                }
            }
        }

    }
}
