#pragma once

#include <security/ant-secret/secret-search/internal/ctx.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NSecretSearch {
    struct TSearchOptions {
        size_t MaxFileSize = 0;
        TVector<TString> Excludes;
        bool Validate = false;
        bool ValidOnly = false;
        bool WithSourceLine = false;

        NSSInternal::TContext InternalCtx() const {
            return NSSInternal::TContext{
                .MaxFileSize = MaxFileSize,
                .Validate = Validate || ValidOnly,
                .ValidOnly = ValidOnly,
                .WithSourceLine = WithSourceLine,
                .Validator = MakeHolder<NValidation::TValidator>(
                        GetEnv("ANT_VALIDATION_ENDPOINT", "http://ant.sec.yandex-team.ru/api/v1/validate/"),
                    "ant.sec.yandex-team.ru",
                    GetEnv("ANT_INTERNAL_TOKEN"))};
        }
    };

}
