#pragma once

#include "search_options.h"
#include "search_result.h"
#include "source.h"

#include <security/ant-secret/secret-search/public/cpp/output/interface.h>
#include <security/ant-secret/secret-search/internal/search_worker.h>
#include <security/ant-secret/secret-search/internal/searchers.h>
#include <security/ant-secret/secret-search/internal/filewalker/filewalker.h>

#include <library/cpp/json/json_value.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/hash.h>
#include <util/folder/path.h>
#include <util/thread/pool.h>

namespace NSecretSearch {
    class ISearcher {
    public:
        virtual ~ISearcher() = default;

        virtual TMaybe<TSourceResult> CheckSource(ISource& source) = 0;

        // TODO(buglloc): CheckStruct
        virtual TVector<TStructResult> CheckStruct(NJson::TJsonValue& root) = 0;

        virtual TVector<TPathResult> CheckPath(const TFsPath& path) = 0;
    };

    class TSearcher: public ISearcher {
    public:
        explicit TSearcher(const TSearchOptions& opts);

        TMaybe<TSourceResult> CheckSource(ISource& source) override;

        TVector<TStructResult> CheckStruct(NJson::TJsonValue& root) override;

        TVector<TPathResult> CheckPath(const TFsPath& path) override;


    protected:
        TSearchOptions opts;
        NSSInternal::TContext ctx;
        THolder<NSSInternal::TSearchWorker> worker;
    };

    class TSearcherThreaded: public ISearcher {
    public:
        explicit TSearcherThreaded(const TSearchOptions& opts, size_t numThreads);

        TMaybe<TSourceResult> CheckSource(ISource& source) override;

        TVector<TStructResult> CheckStruct(NJson::TJsonValue& root) override;

        TVector<TPathResult> CheckPath(const TFsPath& path) override;

    protected:
        TSearchOptions opts;
        NSSInternal::TContext ctx;
        size_t numThreads;
        TDeque<NSSInternal::TSearchWorkerThread> workers;
    };

}
