#pragma once

#include "search_options.h"
#include "search_result.h"
#include "stream_output.h"
#include "source.h"

#include <security/ant-secret/secret-search/public/cpp/output/interface.h>
#include <security/ant-secret/secret-search/internal/search_worker.h>
#include <security/ant-secret/secret-search/internal/searchers.h>
#include <security/ant-secret/secret-search/internal/filewalker/filewalker.h>

#include <library/cpp/json/json_value.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/hash.h>
#include <util/folder/path.h>
#include <util/thread/pool.h>

namespace NSecretSearch {
    class ISearcherStream {
    public:
        virtual bool CheckSource(ISource& source) = 0;

        virtual bool CheckStruct(NJson::TJsonValue& root) = 0;

        virtual bool CheckPath(const TFsPath& path) = 0;
    };

    class TSearcherStream: public ISearcherStream {
    public:
        explicit TSearcherStream(const TSearchOptions& opts, NOutput::IWriter* writer);

        bool CheckSource(ISource& source) override;

        bool CheckStruct(NJson::TJsonValue& root) override;

        bool CheckPath(const TFsPath& path) override;

    protected:
        TSearchOptions opts;
        NSSInternal::TContext ctx;
        THolder<NOutput::IWriter> output;
        THolder<NSSInternal::TSearchWorker> worker;
    };

    class TSearcherStreamThreaded: public ISearcherStream {
    public:
        explicit TSearcherStreamThreaded(const TSearchOptions& opts, NOutput::IWriter* writer, size_t numThreads);

        bool CheckSource(ISource& source) override;

        bool CheckStruct(NJson::TJsonValue& root) override;

        bool CheckPath(const TFsPath& path) override;

    protected:
        TSearchOptions opts;
        NSSInternal::TContext ctx;
        TStreamOutput output;
        size_t numThreads;
        TDeque<NSSInternal::TSearchWorkerThread> workers;
    };

}
