#pragma once

#include "search_result.h"

#include <security/ant-secret/secret-search/public/cpp/output/interface.h>

#include <util/generic/string.h>
#include <util/thread/pool.h>

namespace NSecretSearch {
    class TStreamOutput
       : public IThreadFactory::IThreadAble {
    public:
        explicit TStreamOutput(NOutput::IWriter* writer)
            : writer(writer)
            , messagesQueue(nullptr)
        {
        }

        ~TStreamOutput() override {
            if (T_) {
                T_->Join();
            }
        }

        void Start(TPathResultQueue* queue) {
            messagesQueue = queue;
            T_ = SystemThreadFactory()->Run(this);
        }

        void Finish() {
            messagesQueue->Stop();
            if (T_) {
                T_->Join();
                T_.Destroy();
            }
        }

        void Write(const TPathResult& result) {
            messagesQueue->Push(result);
        }

        void DoExecute() override {
            writer->Start();
            while (true) {
                auto maybeData = messagesQueue->Pop();
                if (maybeData.Empty()) {
                    writer->Finish();
                    break;
                }

                empty = false;
                writer->Write(maybeData.GetRef());
            }
        }

        NOutput::IWriter* GetWriter() {
            return writer.Get();
        }

        bool Empty() {
            return empty;
        }

    protected:
        THolder<NOutput::IWriter> writer;
        TPathResultQueue* messagesQueue;
        TAutoPtr<IThreadFactory::IThread> T_;
        bool empty = true;
    };

}
