#include "simple.h"

#include <library/cpp/json/json_reader.h>

namespace NSecretSearch {
    TSimpleSearcher::TSimpleSearcher(const TSearchOptions& opts)
        : searcher(opts)
    {
    }

    TMaybe<TSourceResult> TSimpleSearcher::CheckSource(const TString& content) {
        NSSInternal::TSourceContent source(content);
        return searcher.CheckSource(source);
    }

    TVector<TPathResult> TSimpleSearcher::CheckPath(const TString& path) {
        return searcher.CheckPath(path);
    }

    TVector<TStructResult> TSimpleSearcher::CheckJson(const TString& content) {
        NJson::TJsonValue root;
        NJson::ReadJsonTree(content, &root, true);
        return searcher.CheckStruct(root);
    }

}
