#pragma once

#include <util/generic/string.h>
#include <util/generic/strbuf.h>
#include <util/generic/deque.h>
#include <util/generic/yexception.h>

namespace NSecretSearchServer {
    struct TDiffParseException: public virtual yexception {
    };

    struct TDiffLine {
        size_t LineNo = 0;
        TStringBuf Line;
    };

    struct TDiff {
        TString SourceFile;
        TString TargetFile;
        TDeque<TDiffLine> Removed;
        TDeque<TDiffLine> Added;
    };

    using TPatchSet = TDeque<TDiff>;

    TPatchSet ParsePatchSet(const TString& source);

}
