#include "diff_source.h"

namespace NSecretSearchServer {
    TSourceDiff::TSourceDiff(const TString& path, const TDeque<TDiffLine>& lines)
        : path(path)
        , lines(lines)
    {
    }

    const TStringBuf TSourceDiff::Head(size_t len) {
        if (Y_UNLIKELY(lines.empty())) {
            return nullptr;
        }

        auto line = lines[0].Line;
        return TStringBuf(line.data(), std::min(len, line.size()));
    }

    const TStringBuf TSourceDiff::Content() {
        if (Y_UNLIKELY(lines.empty())) {
            return nullptr;
        }

        if (!content) {
            bool first = true;
            for (const auto& line : lines) {
                if (!first) {
                    content += '\n';
                }
                first = false;
                content += line.Line;
            }
        }
        return content;
    }

    const TFsPath TSourceDiff::Path() {
        return path;
    }

    bool TSourceDiff::IsBinary() {
        // We _always_ have a text diffs
        return false;
    }

    bool TSourceDiff::IsLocal() {
        return false;
    }

    bool TSourceDiff::IsFulfilled() {
        return !lines.empty() && lines[0].LineNo == 1;
    }

    size_t TSourceDiff::Size() {
        if (Y_UNLIKELY(lines.empty())) {
            return 0;
        }

        if (!size) {
            for (const auto& line : lines) {
                size += line.Line.size();
            }
        }
        return size;
    }

    bool TSourceDiff::ReadLine(size_t& lineNo, TStringBuf& line) {
        if (curLine < lines.size()) {
            auto diffLine = lines[curLine++];
            line = diffLine.Line;
            lineNo = diffLine.LineNo;
            return true;
        }
        return false;
    }

}
