#pragma once

#include "diff.h"
#include <security/ant-secret/secret-search/internal/source.h>

namespace NSecretSearchServer {
    class TSourceDiff: public NSSInternal::ISource {
    public:
        TSourceDiff(const TString& path, const TDeque<TDiffLine>& lines);

        const TStringBuf Head(size_t len) override;

        const TStringBuf Content() override;

        const TFsPath Path() override;

        bool IsBinary() override;

        bool IsLocal() override;

        bool IsFulfilled() override;

        bool ReadLine(size_t& lineNo, TStringBuf& line) override;

        size_t Size() override;

    protected:
        size_t size = 0;
        size_t curLine = 0;
        const TFsPath path;
        const TDeque<TDiffLine> lines;
        TString content;
    };

}
