#include "search_worker.h"

namespace NSecretSearchServer {
    void TSearchWorker::DoExecute() {
        while (true) {
            auto maybeSource = jobsQueue->Pop();
            if (maybeSource.Empty())
                break;

            auto source = maybeSource.GetRef();
            auto result = CheckSource(source);
            if (result.Defined()) {
                resultsQueue->Push(
                    NSSInternal::TPathResult{
                        .Path = source.Path(),
                        .SearcherResults = result.GetRef()});
            }
        }
    }

}
