#pragma once

#include "diff_source.h"

#include <security/ant-secret/secret-search/internal/ctx.h>
#include <security/ant-secret/secret-search/internal/search_worker.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NSecretSearchServer {
    using TJobsQueue = NThreading::TBlockingQueue<TSourceDiff>;

    class TSearchWorker
       : public NSSInternal::TSearchWorkerBase,
          public IThreadFactory::IThreadAble {
    public:
        explicit TSearchWorker(NSSInternal::TContext& ctx)
            : TSearchWorkerBase(ctx)
        {
        }

        void ResetState(TJobsQueue* jobs, NSSInternal::TPathResultQueue* results) {
            jobsQueue = jobs;
            resultsQueue = results;
        }

        void DoExecute() override;

    protected:
        TJobsQueue* jobsQueue = nullptr;
        NSSInternal::TPathResultQueue* resultsQueue = nullptr;
    };

}
