#pragma once

#include "diff.h"
#include "search_worker.h"
#include "validator.h"

#include <security/ant-secret/secret-search/internal/ctx.h>
#include <security/ant-secret/secret-search/internal/search_worker.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NSecretSearchServer {
    struct TSearchOptions {
        TVector<TString> Excludes;
        bool Validate = false;
        bool ValidOnly = false;

        NSSInternal::TContext InternalCtx() const {
            return NSSInternal::TContext{
                .Validate = Validate || ValidOnly,
                .ValidOnly = ValidOnly,
            };
        }
    };

    class TSearcher {
    public:
        TSearcher(const TSearchOptions& opts, size_t numThreads);

        TMaybe<NSSInternal::TSourceResult> CheckContent(const TString& input);

        TVector<NSSInternal::TPathResult> CheckPatchSet(const TString& input);

    protected:
        TSearchOptions opts;
        NSSInternal::TContext ctx;
        size_t numThreads;
        TDeque<TSearchWorker> workers;
    };

}
