#pragma once

#include "searcher.h"

#include <library/cpp/http/misc/parsed_request.h>
#include <library/cpp/http/server/http.h>
#include <library/cpp/http/server/response.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

namespace NSecretSearchServer {
    struct TServerOptions {
        bool ValidateSecrets;
        TString ServerAddr;
        TString TvmToolToken;
        TVector<size_t> AllowedTvms;
    };

    void StartServer(const TServerOptions& opts);

    class TSearchReplier: public TRequestReplier {
    public:
        TSearchReplier(const TVector<size_t>& allowedTvms, const TString& TvmToolToken, bool validateSecrets=true);

        bool DoReply(const TReplyParams& params) override;

    protected:
        bool CheckAuth(const TString& serviceTicket);

    protected:
        const TVector<size_t>& allowedTvms;
        const TString& tvmToolToken;
        TSearcher searcher;
    };

    class THttpCallback: public THttpServer::ICallBack {
    public:
        THttpCallback(TVector<size_t> allowedTvms, TString tvmToolToken, bool validateSecrets=true)
            : allowedTvms(std::move(allowedTvms))
            , tvmToolToken(std::move(tvmToolToken))
            , validateSecrets(validateSecrets)
        {
        }

        TClientRequest* CreateClient() override {
            return new TSearchReplier(allowedTvms, tvmToolToken, validateSecrets);
        }

    protected:
        const TVector<size_t> allowedTvms;
        const TString tvmToolToken;
        const bool validateSecrets;
    };

}
