#include "validator.h"

#include <util/generic/maybe.h>

namespace NSecretSearchServer {
    TValidator::TValidator(const TString& baseUrl, TPatchSet* patchSet)
        : NValidation::TValidator(baseUrl)
        , patchSet(patchSet)
    {
    }

    TValidator::TValidator(const TString& baseUrl)
        : TValidator(baseUrl, nullptr)
    {
    }

    TMaybe<NValidation::TResult>
    TValidator::Call(const TStringBuf type, const TStringBuf token) {
        if (patchSet != nullptr && !patchSet->empty()) {
            for (auto&& diff : *patchSet) {
                for (const auto& line : diff.Removed) {
                    if (line.Line.Contains(token)) {
                        return Nothing();
                    }
                }
            }
        }

        return NValidation::TValidator::Call(type, token);
    }

    std::pair<bool, bool>
    TValidator::CallSsl(const TString& serial, const TVector<TString>& chain, bool isClient, bool isServer) {
        return NValidation::TValidator::CallSsl(serial, chain, isClient, isServer);
    }

}
