#pragma once

#include "diff.h"
#include <security/ant-secret/internal/validation/validator.h>

namespace NSecretSearchServer {
    class TValidator: public NValidation::TValidator {
    public:
        explicit TValidator(const TString& baseUrl);

        TValidator(const TString& baseUrl, TPatchSet* patchSet);

        TMaybe<NValidation::TResult>
        Call(const TStringBuf type, const TStringBuf token) override;

        std::pair<bool, bool>
        CallSsl(const TString& serial, const TVector<TString>& chain, bool isClient, bool isServer) override;

    protected:
        TPatchSet* patchSet;
    };

}
