#include <security/ant-secret/secret-search/server/lib/diff.h>
#include <security/ant-secret/secret-search/server/lib/diff_source.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TSourceDiffTests) {
    using namespace NSecretSearchServer;

    Y_UNIT_TEST(Simple) {
        const TDeque<TDiffLine>& lines{
            {1, "test"},
            {2, "foo"},
            {3, "bar"},
        };
        TSourceDiff diff("/tmp/test", lines);
        UNIT_ASSERT_STRINGS_EQUAL(diff.Path().GetPath(), "/tmp/test");
        UNIT_ASSERT_VALUES_EQUAL(diff.Size(), 10);
        UNIT_ASSERT(diff.IsFulfilled());
        UNIT_ASSERT(!diff.IsBinary());
        UNIT_ASSERT(!diff.IsLocal());
        UNIT_ASSERT_STRINGS_EQUAL(diff.Head(3), "tes");

        size_t lineNo;
        TStringBuf line;
        UNIT_ASSERT(diff.ReadLine(lineNo, line));
        UNIT_ASSERT_VALUES_EQUAL(lineNo, 1);
        UNIT_ASSERT_STRINGS_EQUAL(line, "test");

        UNIT_ASSERT(diff.ReadLine(lineNo, line));
        UNIT_ASSERT_VALUES_EQUAL(lineNo, 2);
        UNIT_ASSERT_STRINGS_EQUAL(line, "foo");

        UNIT_ASSERT(diff.ReadLine(lineNo, line));
        UNIT_ASSERT_VALUES_EQUAL(lineNo, 3);
        UNIT_ASSERT_STRINGS_EQUAL(line, "bar");

        UNIT_ASSERT_STRINGS_EQUAL(diff.Content(), "test\nfoo\nbar");
    }
}
