#include <security/ant-secret/secret-search/server/lib/searcher.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TSearcherTests) {
    using namespace NSecretSearchServer;

    Y_UNIT_TEST(Diff) {
        TString notSecretContent(R"(
--- /dev/null 2018-11-11 02:06:52.413332804 +0300
+++ not_secret 2018-11-11 16:48:46.818852146 +0300
@@ -0,0 +1 @@
+something
)");
        TString secretContent(R"(
--- /dev/null 2018-11-11 02:06:52.413332804 +0300
+++ secret 2018-11-11 16:49:26.012727583 +0300
@@ -0,0 +1,2 @@
+telegram_token = '329142621:AAEYEkfcQ8wVpPFeQCY8IRY2M7dUVQ6ULuY'
+oauth = '03c7c0ace395d80182db07ae2c30f034'
)");
        TSearcher searcher(TSearchOptions{.Validate = false, .ValidOnly = false}, 2);
        auto results = searcher.CheckPatchSet(notSecretContent);
        UNIT_ASSERT(results.empty());

        results = searcher.CheckPatchSet(secretContent);
        UNIT_ASSERT_VALUES_EQUAL(results.size(), 1);
        auto pathResult = results[0];
        UNIT_ASSERT_STRINGS_EQUAL(pathResult.Path, "secret");
        UNIT_ASSERT_VALUES_EQUAL(pathResult.SearcherResults.size(), 2);
    }

    Y_UNIT_TEST(Content) {
        TString notSecretContent(R"(something
)");
        TString secretContent(R"(
telegram_token = '329142621:AAEYEkfcQ8wVpPFeQCY8IRY2M7dUVQ6ULuY'
oauth = '03c7c0ace395d80182db07ae2c30f034'
)");
        TSearcher searcher(TSearchOptions{.Validate = false, .ValidOnly = false}, 2);
        auto results = searcher.CheckContent(notSecretContent);
        UNIT_ASSERT(!results.Defined());

        results = searcher.CheckContent(secretContent);
        UNIT_ASSERT(results.Defined());
        UNIT_ASSERT_VALUES_EQUAL(results.GetRef().size(), 2);
    }
}
