#include <security/ant-secret/snooper/cpp/logger/masked.h>

#include <library/cpp/logger/stream.h>
#include <library/cpp/logger/log.h>
#include <library/cpp/getopt/last_getopt.h>

int main(int argc, char** argv) {
    using namespace NLastGetopt;
    TOpts opts = TOpts::Default();

    opts.SetTitle("Snooper logger example");

    bool validOnly;
    opts.AddLongOption("valid-only", "search with validation")
        .DefaultValue(false)
        .StoreResult(&validOnly);

    TOptsParseResult args(&opts, argc, argv);

    TAutoPtr<TLogBackend> streamBackend = new TStreamLogBackend(&Cout);
    TAutoPtr<TLogBackend> maskedBackend = new NSnooper::TMaskedLogBackend(streamBackend.Get());
    TLog log(MakeHolder<TThreadedLogBackend>(maskedBackend.Get()));
    TString line;
    while (Cin.ReadLine(line)) {
        log << line << Endl;
    }
}
