#include "masked.h"

#include <library/cpp/logger/record.h>
#include <util/system/guard.h>

namespace NSnooper {
    TMaskedLogBackend::TMaskedLogBackend(TLogBackend* slave)
        : slave(slave)
        , snooper(TSnooper())
        , searcher(snooper.Searcher())
    {
    }

    TMaskedLogBackend::TMaskedLogBackend(TLogBackend* slave, TSecretTypes neededSecrets)
        : slave(slave)
        , snooper(TSnooper())
        , searcher(snooper.Searcher(neededSecrets))
    {
    }

    void TMaskedLogBackend::WriteData(const TLogRecord& rec) {
        TString data{rec.Data, rec.Len};
        with_lock (lock) {
            searcher->Mask(data);
        }
        slave->WriteData({rec.Priority, data.Data(), data.length()});
    }

    void TMaskedLogBackend::ReopenLog() {
        slave->ReopenLog();
    }

    void TMaskedLogBackend::ReopenLogNoFlush() {
        slave->ReopenLogNoFlush();
    }
}
