#pragma once

#include <security/ant-secret/snooper/cpp/secret.h>
#include <security/ant-secret/snooper/cpp/snooper.h>

#include <library/cpp/logger/backend.h>

#include <util/system/mutex.h>

namespace NSnooper {
    class TMaskedLogBackend: public TLogBackend {
    public:
        explicit TMaskedLogBackend(TLogBackend* slave);

        TMaskedLogBackend(TLogBackend* slave, TSecretTypes neededSecrets);

        void WriteData(const TLogRecord& rec) override;

        void ReopenLog() override;

        void ReopenLogNoFlush() override;

    private:
        TLogBackend* slave;
        TSnooper snooper;
        THolder<TSearcher> searcher;
        TMutex lock;
    };
}