#include <security/ant-secret/snooper/cpp/logger/masked.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/logger/stream.h>
#include <library/cpp/logger/log.h>

#include <util/stream/str.h>


Y_UNIT_TEST_SUITE(TMaskedLogger) {
    using namespace NSnooper;
    TString secretContent = R"(
GET /test?sessionid=3%3A1566480756.5.0.1564091077870%3AYWgJJQ%3A88.1%7C1120000000038691.0.2002%7C1120000000049208.490331.2002.2%3A490331%7C142241.804415.ySsdPJeQSM1Zoj32qOMvTKSWVxM HTTP/1.1
Host: localhost:9000
User-Agent: HTTPie/1.0.2
Accept-Encoding: gzip, deflate
Accept: */*
Connection: keep-alive
X-Ya-Service-Ticket: 3:serv:CBAQ__________9_IgQIehAD:Jp93z7FrOT2IOaPtAD3s7_zFU6DJrL3HvHbYJKu9Cet5ytYSKzseN-SVmIMH5y4UM51XtJcV3mvD1rv6w_dzt36PxpS7R7EAPbQWkP6wJGQRdKWjmAWkkqD-s062kL4q39fG0hJwxe4s-8zDh5hCXTimzZvFrdo09hQcfFAoj-cJp93z7FrOT2IOaPtAD3s7_zFU6DJrL3HvHbYJKu9Cet5ytYSKzseN-SVmIMH5y4UM51XtJcV3mvD1rv6w_dzt36PxpS7R7EAPbQWkP6wJGQRdKWjmAWkkqD-s062kL4q39fG0hJwxe4s-8zDh5hCXTimzZvFrdo09hQcfFAoj-c
Cookie: yandexuid=654321; Session_id=3:1566480756.5.0.1564091077870:YWgJJQ:88.1|1120000000038691.0.2002|1120000000049208.490331.2002.2:490331|142241.804415.ySsdPJeQSM1Zoj32qOMvTKSWVxM; sessionid2=3:1566820123.5.0.1564091077870:YWgJJQ:88.1|1120000000038691.0.2002|1120000000049208.-1.0|142429.844023.OJbvg_ahfMoFX22xPvf-iEoVNsk; something=brown;
Authorization: OAuth AgAAAAAHYVLuAAX_m477zavGV0GMlcItT-kpRm1

)";

    TString maskedContent = R"(
GET /test?sessionid=3%3A1566480756.5.0.1564091077870%3AYWgJJQ%3A88.1%7C1120000000038691.0.2002%7C1120000000049208.490331.2002.2%3A490331%7C142241.804415.XXXXXXXXXXXXXXXXXXXXXXXXXXX HTTP/1.1
Host: localhost:9000
User-Agent: HTTPie/1.0.2
Accept-Encoding: gzip, deflate
Accept: */*
Connection: keep-alive
X-Ya-Service-Ticket: 3:serv:CBAQ__________9_IgQIehAD:XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
Cookie: yandexuid=654321; Session_id=3:1566480756.5.0.1564091077870:YWgJJQ:88.1|1120000000038691.0.2002|1120000000049208.490331.2002.2:490331|142241.804415.XXXXXXXXXXXXXXXXXXXXXXXXXXX; sessionid2=3:1566820123.5.0.1564091077870:YWgJJQ:88.1|1120000000038691.0.2002|1120000000049208.-1.0|142429.844023.XXXXXXXXXXXXXXXXXXXXXXXXXXX; something=brown;
Authorization: OAuth AgAAAAAHYVLuAAX_m4XXXXXXXXXXXXXXXXXXXXX

)";

    Y_UNIT_TEST(Simple) {

        TStringStream outputData;
        TStringStream maskedData;
        {
            TStreamLogBackend streamBackend(&outputData);
            TLog log(MakeHolder<TMaskedLogBackend>(&streamBackend));

            log << "lala" << Endl;
            maskedData << "lala" << Endl;
            log << secretContent << Endl;
            maskedData << maskedContent << Endl;
            log << "blabla" << Endl;
            maskedData << "blabla" << Endl;
        }

        UNIT_ASSERT_VALUES_EQUAL(outputData.Str(), maskedData.Str());
    }
}
