#pragma once

#include "searcher.h"
#include "secret.h"

#include <security/ant-secret/snooper/internal/ctx.h>
#include <security/ant-secret/internal/validation/validator.h>

namespace NSnooper {
    class TSnooper {
    public:
        explicit TSnooper() {
            ctx = NSnooperInt::TContext{
                .Validator = MakeHolder<NValidation::TValidator>("http://ant.sec.yandex-team.ru/api/v1/validate/"),
            };
        }

        THolder<TSearcher> Searcher(TSecretTypes neededSecrets = NSecret::ESecretType::All) {
            return MakeHolder<TSearcher>(ctx, NSnooperInt::TSearcherOpts{
                                                  .SecretTypes = neededSecrets,
                                              });
        }

        TSearcher* NewSearcher(TSecretTypes neededSecrets = NSecret::ESecretType::All) {
            return new TSearcher(ctx, NSnooperInt::TSearcherOpts{
                                          .SecretTypes = neededSecrets,
                                      });
        }

    protected:
        NSnooperInt::TContext ctx;
    };

}
