#include <security/ant-secret/snooper/cpp/snooper.h>
#include <security/ant-secret/snooper/cpp/searcher.h>

#include <util/generic/strbuf.h>
#include <library/cpp/getopt/last_getopt.h>

int main(int argc, char** argv) {
    using namespace NLastGetopt;
    TOpts opts = TOpts::Default();

    opts.SetTitle("Snooper example");

    bool validOnly;
    opts.AddLongOption("valid-only", "search with validation")
        .DefaultValue(false)
        .StoreResult(&validOnly);

    bool maskInput;
    opts.AddLongOption("mask", "mask input")
        .DefaultValue(false)
        .StoreResult(&maskInput);

    TOptsParseResult args(&opts, argc, argv);

    NSnooper::TSnooper snooper;
    auto searcher = snooper.Searcher(NSnooper::ESecretType::All);
    TString line;
    while (Cin.ReadLine(line)) {
        if (maskInput) {
            searcher->Mask(line, validOnly);
            Cout << line << Endl;
        } else {
            auto results = searcher->Search(line, validOnly);
            if (!results) {
                continue;
            }

            Cout << "line: " << line << Endl;
            Cout << "result:" << Endl;
            for (auto&& result : results) {
                Cout << "\t- type: " << result.Type << Endl;
                Cout << "\t- secret: " << result.Secret << Endl;
                Cout << "\t- secret pos: [" << result.SecretPos.From << ":" << result.SecretPos.From + result.SecretPos.Len << "]" << Endl;
                Cout << "\t- mask pos: [" << result.MaskPos.From << ":" << result.MaskPos.From + result.MaskPos.Len << "]" << Endl;
                Cout << "\t-- " << Endl;
            }

            Cout << Endl;
        }
    }
}