#pragma once

#include "ctx.h"
#include <security/ant-secret/internal/validation/validator.h>
#include <security/ant-secret/internal/regex_storage/storage.h>
#include <security/ant-secret/snooper/internal/secret/secret.h>
#include <security/ant-secret/snooper/internal/searchers/interface.h>

namespace NSnooperInt {
    namespace {
        constexpr char kMaskChar = 'X';
    }

    struct TSearcherOpts {
        NSecret::TSecretTypes SecretTypes = NSecret::ESecretType::All;
    };

    class TSearcher {
    public:
        TSearcher(TContext& ctx, TSearcherOpts opts);

        NSecret::TSecretList Search(TStringBuf data, bool validOnly = false);

        NSecret::TSecretList Mask(TString& data, bool validOnly = false);

        inline void MaskAtSecrets(TString& data, NSecret::TSecretList& secrets) {
            for (auto&& secret : secrets) {
                std::fill(data.begin() + secret.MaskPos.From, data.begin() + secret.MaskPos.From + secret.MaskPos.Len, kMaskChar);
            }
        }

        void CollectRegexes();

    protected:
        TContext& ctx;
        TSearcherOpts opts;
        TVector<THolder<NSearchers::ISearcher>> searchers;
        NSSInternal::TRegexHolder keysRe;
        THashMap<size_t, std::pair<size_t, size_t>> keyToSearcher;
    };

}

