#pragma once

#include <security/ant-secret/snooper/internal/secret/secret.h>

#include <util/generic/vector.h>
#include <util/generic/strbuf.h>
#include <util/generic/maybe.h>

namespace NSearchers {
    struct TSearchRequest {
        TStringBuf data;
        size_t keyFrom;
        size_t keyTo;
        size_t keyId;
    };

    class ISearcher {
    public:
        virtual ~ISearcher() = default;

        virtual TMaybe<NSecret::TSecret> Search(const TSearchRequest& req) = 0;

        virtual TMaybe<NSecret::TSecret> SearchValidated(const TSearchRequest& req) = 0;

        virtual TVector<TString> KeyPatterns() const = 0;

        inline virtual TString Name() const = 0;

        inline virtual TMaybe<bool> ForceValid() const = 0;
    };

}
