#pragma once

#include "prefixed.h"

#include <security/libs/cpp/hyperscan/hyperscan.h>

namespace NSearchers {
    class TMdsSign: public TPrefixed {
    public:
        explicit TMdsSign(NSnooperInt::TContext& ctx);

        TString Name() const override;

    protected:
        bool IsSecret(size_t id, TStringBuf secret) override;

        NSecret::TPos MaskSecret(size_t id, const TStringBuf rawSecret) override;

        NSecret::ESecretType SecretType() const override;

        TMaybe<bool> ForceValid() const override;
    };

}
