#pragma once

#include "utils.h"

#include <security/ant-secret/snooper/internal/ctx.h>
#include <security/libs/cpp/hyperscan/hyperscan.h>

#include <util/generic/string.h>
#include <util/generic/strbuf.h>
#include <util/generic/vector.h>

namespace NSearchers {
    class TPrefixed: public ISearcher {
    public:
        TPrefixed(NSnooperInt::TContext& ctx, const TVector<TString>& keys, const TVector<TString>& values);

        TMaybe<NSecret::TSecret> Search(const TSearchRequest& req) override;

        TMaybe<NSecret::TSecret> SearchValidated(const TSearchRequest& req) override;

        TVector<TString> KeyPatterns() const override;

    protected:
        inline virtual NSecret::ESecretType SecretType() const = 0;

        virtual bool IsSecret(size_t id, TStringBuf secret) = 0;

        virtual NSecret::TPos MaskSecret(size_t id, const TStringBuf rawSecret) = 0;

    protected:
        NSnooperInt::TContext& ctx;
        TVector<TString> keyPatterns;
        NSSInternal::TRegexHolder re;
    };

}
