#pragma once

#include "prefixed.h"

#include <security/libs/cpp/hyperscan/hyperscan.h>

namespace NSearchers {
    class TS3Presign: public TPrefixed {
    public:
        explicit TS3Presign(NSnooperInt::TContext& ctx);

        TString Name() const override;

    protected:
        bool IsSecret(size_t id, TStringBuf secret) override;

        NSecret::TPos MaskSecret(size_t id, const TStringBuf rawSecret) override;

        NSecret::ESecretType SecretType() const override;

        TMaybe<bool> ForceValid() const override;
    };

}
