#pragma once

#include "whole.h"

#include <security/libs/cpp/hyperscan/hyperscan.h>

namespace NSearchers {
    class TTvmServiceTicket: public TWhole {
    public:
        explicit TTvmServiceTicket(NSnooperInt::TContext& ctx);

        TString Name() const override;

    protected:
        bool IsSecret(size_t id, TStringBuf token) override;

        NSecret::TPos MaskSecret(size_t id, const TStringBuf rawSecret) override;

        NSecret::ESecretType SecretType() const override;

        TMaybe<bool> ForceValid() const override;
    };

}
