#include "tvm_user.h"

#include <security/ant-secret/internal/string_utils/common.h>

#include <util/string/vector.h>

namespace NSearchers {
    namespace {
        const TVector<TString> kValuePatterns{
            R"(3\:user\:[\w\-]+\:[\w\-]{342})",
        };

        bool isUserTicket(const TStringBuf rawTicket) {
            TStringBuf ticket;
            if (!rawTicket.AfterPrefix("3:user:", ticket)) {
                return false;
            }

            TStringBuf sign = ticket.After(':');
            if (NStringUtils::IsMasked(sign, 100)) {
                return false;
            }

            TStringBuf body = ticket.Before(':');
            return NStringUtils::IsBase64Url(body) && NStringUtils::IsBase64Url(sign);
        }
    }

    TTvmUserTicket::TTvmUserTicket(NSnooperInt::TContext& ctx)
        : TWhole(ctx, kValuePatterns)
    {
    }

    bool TTvmUserTicket::IsSecret(size_t id, const TStringBuf secret) {
        Y_UNUSED(id);
        return isUserTicket(secret);
    }

    NSecret::TPos TTvmUserTicket::MaskSecret(size_t id, const TStringBuf rawSecret) {
        Y_UNUSED(id);

        return {
            .From = rawSecret.length() - 342,
            .Len = 342,
        };
    }

    TString TTvmUserTicket::Name() const {
        return "tvm-user-ticket";
    }

    NSecret::ESecretType TTvmUserTicket::SecretType() const {
        return NSecret::ESecretType::TVMTicket;
    }

    TMaybe<bool> TTvmUserTicket::ForceValid() const {
        return true;
    }
}
