#pragma once

#include "interface.h"
#include <library/cpp/string_utils/quote/quote.h>

#include <security/ant-secret/internal/regex_storage/storage.h>
#include <security/libs/cpp/hyperscan/hyperscan.h>

namespace NSearchers {
    inline TString decodeSecret(const TStringBuf data) {
        // decode urlencoded
        if (data.Contains("%")) {
            return UrlUnescapeRet(data);
        }
        return TString{data};
    }

    NSSInternal::TRegexHolder CompilePatterns(
        const TString& name,
        const TVector<TString>& patterns,
        unsigned int flag);

}
