#include "yc_static_cred.h"

#include <security/ant-secret/internal/string_utils/common.h>

#include <library/cpp/string_utils/base64/base64.h>
#include <library/cpp/digest/crc32c/crc32c.h>

namespace NSearchers {
    namespace {
        // https://st.yandex-team.ru/ANTSECRET-82
        const TVector<TString> kValuePatterns{
            R"(YC[A-Za-z0-9_-]{38})",
        };
    }

    TYCStaticCred::TYCStaticCred(NSnooperInt::TContext& ctx)
            : TWhole(ctx, kValuePatterns)
    {
    }

    bool TYCStaticCred::IsSecret(size_t id, const TStringBuf token) {
        Y_UNUSED(id);

        TString decoded = Base64StrictDecode(token);
        if (decoded.empty()) {
            return false;
        }

        ui32 expectedChecksum = NStringUtils::FromBytesMsb<ui32>(decoded, decoded.size() - 4);
        ui32 actualChecksum = Crc32c(decoded.data(), decoded.size() - 4);
        return actualChecksum == expectedChecksum;
    }

    NSecret::TPos TYCStaticCred::MaskSecret(size_t id, const TStringBuf rawSecret) {
        Y_UNUSED(id, rawSecret);

        return {
            .From = 2,
            .Len = 38,
        };
    }

    TString TYCStaticCred::Name() const {
        return "yc-static-cred";
    }

    NSecret::ESecretType TYCStaticCred::SecretType() const {
        return NSecret::ESecretType::YCStaticCred;
    }

    TMaybe<bool> TYCStaticCred::ForceValid() const {
        return false;
    }
}
