#pragma once

#include "whole.h"

#include <security/libs/cpp/hyperscan/hyperscan.h>

namespace NSearchers {
    class TYCToken: public TWhole {
    public:
        explicit TYCToken(NSnooperInt::TContext& ctx);

        TString Name() const override;

    protected:
        bool IsSecret(size_t id, TStringBuf token) override;

        NSecret::TPos MaskSecret(size_t id, const TStringBuf rawSecret) override;

        NSecret::ESecretType SecretType() const override;

        TMaybe<bool> ForceValid() const override;
    };

}
