#pragma once

#include <util/system/types.h>
#include <util/generic/flags.h>

namespace NSecret {
    enum class ESecretType : ui32 {
        Unknown = 0,
        YOAuth = 1 << 0,
        YSession = 1 << 1,
        TVMTicket = 1 << 2,
        S3Presign = 1 << 3,
        MdsSign = 1 << 4,
        YCApiKey = 1 << 5,
        YCCookie = 1 << 6,
        YCToken = 1 << 7,
        YCStaticCred = 1 << 8,
        All = YOAuth | YSession | TVMTicket | S3Presign | YCApiKey | YCCookie | YCToken | YCStaticCred,
        AllWMds = All | MdsSign,
    };

    Y_DECLARE_FLAGS(TSecretTypes, ESecretType)

    Y_DECLARE_OPERATORS_FOR_FLAGS(TSecretTypes)
}
