#include "ru_yandex_security_snooper_NativeSnooper.h"
#include "util.h"

#include <security/ant-secret/snooper/cpp/snooper.h>

NSnooper::TSnooper globalSnooper;

JNIEXPORT jobject JNICALL Java_ru_yandex_security_snooper_NativeSnooper_internalSearch
  (JNIEnv *jenv, jclass, jlong handle, jstring content, jboolean validOnly) {
    NSnooper::TSearcher* instance = reinterpret_cast<NSnooper::TSearcher*>(handle);

    auto stringView = NSnooperJava::TJavaString(jenv, content);
    auto secrets = instance->Search(stringView, validOnly == JNI_TRUE);
    if (!secrets) {
        return nullptr;
    }

    return NSnooperJava::BuildJavaObject(jenv, secrets);
}

JNIEXPORT jstring JNICALL Java_ru_yandex_security_snooper_NativeSnooper_internalMask
  (JNIEnv *jenv, jclass, jlong handle, jstring content, jboolean validOnly) {
    NSnooper::TSearcher* instance = reinterpret_cast<NSnooper::TSearcher*>(handle);

    auto stringView = NSnooperJava::TJavaString(jenv, content);
    auto secrets = instance->Search(stringView, validOnly == JNI_TRUE);
    if (!secrets) {
        return content;
    }

    auto copyString = TString{stringView};
    instance->MaskAtSecrets(copyString, secrets);

    return jenv->NewStringUTF(copyString.data());
}

JNIEXPORT jlong JNICALL Java_ru_yandex_security_snooper_NativeSnooper_factorySearcher
  (JNIEnv *, jclass) {
    return (jlong) globalSnooper.NewSearcher();
}

JNIEXPORT void JNICALL Java_ru_yandex_security_snooper_NativeSnooper_finalizeSearcher
  (JNIEnv *, jclass, jlong handle) {
    delete reinterpret_cast<NSnooper::TSearcher*>(handle);
}
