#include "util.h"
#include <util/generic/vector.h>

namespace NSnooperJava {
    namespace {
        jobject BuildJavaObject(JNIEnv* jenv, const NSnooper::TPos& pos) {
            jclass cls = jenv->FindClass("ru/yandex/security/snooper/Pos");
            jobject res = jenv->AllocObject(cls);

            jenv->SetLongField(res, jenv->GetFieldID(cls, "from", "J"), pos.From);
            jenv->SetLongField(res, jenv->GetFieldID(cls, "len", "J"), pos.Len);
            return res;
        }
    }

    jobject BuildJavaObject(JNIEnv* jenv, const NSnooper::TSecretList& secrets) {
        jclass secretCls = jenv->FindClass("ru/yandex/security/snooper/Secret");
        auto secretsArray = jenv->NewObjectArray(secrets.size(), secretCls, NULL);

        size_t i = 0;
        for (const auto& secret : secrets) {
            jobject secretObj = jenv->AllocObject(secretCls);

            jenv->SetObjectField(secretObj, jenv->GetFieldID(secretCls, "secret", "Ljava/lang/String;"), jenv->NewStringUTF(secret.Secret.c_str()));
            jenv->SetObjectField(secretObj, jenv->GetFieldID(secretCls, "secretPos", "Lru/yandex/security/snooper/Pos;"), BuildJavaObject(jenv, secret.SecretPos));
            jenv->SetObjectField(secretObj, jenv->GetFieldID(secretCls, "maskPos", "Lru/yandex/security/snooper/Pos;"), BuildJavaObject(jenv, secret.MaskPos));

            jenv->SetObjectArrayElement(secretsArray, i, secretObj);
            ++i;
        }

        return secretsArray;
    }
}
