#pragma once

#include <security/ant-secret/snooper/cpp/secret.h>

#include <util/generic/fwd.h>
#include <util/generic/string.h>
#include <jni.h>

namespace NSnooperJava {

    class TJavaString {
    public:
        TJavaString(JNIEnv* jenv, jstring orig)
            : jenv_(jenv)
            , orig_(orig)
            , k_(jenv_->GetStringUTFChars(orig_, nullptr))
        {
        }

        ~TJavaString() {
            jenv_->ReleaseStringUTFChars(orig_, k_);
        }

        operator TStringBuf() const {
            return TStringBuf(k_, jenv_->GetStringUTFLength(orig_));
        }

    private:
        JNIEnv* jenv_;
        jstring orig_;
        const char* k_;
    };

    jobject BuildJavaObject(JNIEnv* jenv, const NSnooper::TSecretList& secrets);
}
