package ru.yandex.security.snooper;

// not thread safe class
public class NativeSnooper {
    public static final Secret[] EMPTY_SECRETS = new Secret[0];

    private long handle;

    public NativeSnooper() {
        this.handle = factorySearcher();
    }

    public Secret[] searchValidated(String line) {
       return doSearch(line, true);
    }

    public String maskValidated(String line) {
        return doMask(line, true);
    }

    public Secret[] search(String line) {
        return doSearch(line, false);
    }

    public String mask(String line) {
        return doMask(line, false);
    }

    private Secret[] doSearch(String line, boolean validOnly) {
        Secret[] secrets = this.internalSearch(this.handle, line, validOnly);
        if (secrets == null) {
            return EMPTY_SECRETS;
        }

        return secrets;
    }

    private String doMask(String line, boolean validOnly) {
        return this.internalMask(this.handle, line, validOnly);
    }

    @SuppressWarnings("deprecation")
    @Override
    protected void finalize() {
        if (this.handle != 0) {
            this.finalizeSearcher(this.handle);
            this.handle = 0;
        }
    }

    private static native Secret[] internalSearch(long handle, String line, boolean validOnly);
    private static native String internalMask(long handle, String line, boolean validOnly);
    private static native String finalizeSearcher(long handle);
    private static native long factorySearcher();

    static {
        SnooperJni.loadLibrary();
    }
}
