package ru.yandex.security.snooper;

public class Pos {
    private long from;
    private long len;

    public Pos(long from, long len) {
        this.from = from;
        this.len = len;
    }

    public long getFrom() {
        return from;
    }

    public long getLen() {
        return len;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (obj.getClass() != this.getClass()) {
            return false;
        }

        final Pos other = (Pos) obj;
        return this.from == other.from && this.len == other.len;
    }

    @Override
    public int hashCode() {
        int result = Long.hashCode(from);
        result = 31 * result + Long.hashCode(len);
        return result;
    }

    @Override
    public String toString() {
        return "Pos[from="
            + from
            + ", len="
            + len
            + "]";
    }
}
