package ru.yandex.security.snooper;

import javax.annotation.Nonnull;

public class Secret {
    private String secret;
    private Pos secretPos;
    private Pos maskPos;

    public Secret(String secret, Pos secretPos, Pos maskPos) {
        this.secret = secret;
        this.secretPos = secretPos;
        this.maskPos = maskPos;
    }

    @Nonnull
    public String getSecret() {
        return secret;
    }

    @Nonnull
    public Pos getSecretPos() {
        return secretPos;
    }

    @Nonnull
    public Pos getMaskPos() {
        return maskPos;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (obj.getClass() != this.getClass()) {
            return false;
        }

        final Secret other = (Secret) obj;
        return (
            this.secret.equals(other.secret)
            && this.secretPos.equals(other.secretPos)
            && this.maskPos.equals(other.maskPos)
        );
    }

    @Override
    public int hashCode() {
        int result = secret.hashCode();
        result = 31 * result + secretPos.hashCode();
        result = 31 * result + maskPos.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Secret[secret="
            + secret.hashCode()
            + ", secretPos="
            + secretPos
            + ", maskPos="
            + maskPos
            + "]";
    }
}
