package ru.yandex.security.snooper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;


public class SnooperJni {
    private static boolean wasCalled = false;

    private SnooperJni() {
    }

    public static synchronized void loadLibrary() {
        if (wasCalled) {
            return;
        }

        try {
            loadFromJar();
            wasCalled = true;
        } catch (RuntimeException e) {
            throw e;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void loadFromJar() throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        String resourcePath = "/" + System.mapLibraryName("snooper_java");

        try (InputStream is = SnooperJni.class.getResourceAsStream(resourcePath)) {
            if (is == null) {
                    throw new FileNotFoundException("File " + resourcePath + " was not found inside JAR.");
            }

            Path tempFile = Files.createTempFile(Paths.get(tempDir), "snooper_java_", ".tmp");

            try {
                Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                System.load(tempFile.toString());
            } finally {
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    File f = new File(tempFile.toString());
                    f.deleteOnExit();
                } else {
                    Files.delete(tempFile);
                }
            }
        }
    }
}
