import sys
from security.ant_secret.snooper import Snooper


def main():
    snooper = Snooper()
    searcher = snooper.searcher()
    for line in sys.stdin.buffer:
        # please use valid_only = True if you really need it
        for secret in searcher.search(line.rstrip(), valid_only=False):
            print('found secret of type %s: %s' % (secret.type, secret.secret))

if __name__ == '__main__':
    main()
