package main

import (
	"context"
	"flag"

	"a.yandex-team.ru/library/go/maxprocs"
	"a.yandex-team.ru/security/ant-secret/web/internal/config"
	"a.yandex-team.ru/security/ant-secret/web/internal/server"
	"a.yandex-team.ru/security/libs/go/simplelog"
)

var (
	cfgPath = "conf.d/web.conf.toml"
)

func main() {
	maxprocs.AdjustYP()

	flag.StringVar(&cfgPath, "cfg", cfgPath, "config path")
	flag.Parse()

	cfg, err := config.LoadConfig(cfgPath, true)
	if err != nil {
		simplelog.Error("failed to load config", "err", err)
		return
	}

	ctx, cancel := context.WithCancel(context.Background())
	defer cancel()

	srv, err := server.NewServer(ctx, cfg)
	if err != nil {
		simplelog.Error("failed create server", "err", err)
		return
	}

	err = srv.ListenAndServe(cfg.Addr)
	if err != nil {
		simplelog.Crit(err.Error())
	}
}
