package searcher

import (
	"fmt"
	"net"
	"net/http"
	"net/http/httputil"
	"time"

	"a.yandex-team.ru/security/libs/go/simplelog"
)

const (
	UpstreamScheme = "http"
	UpstreamHost   = "127.0.0.1:5000"
)

var (
	EmptyResp   = []byte("[]")
	ContentType = "application/json; charset=UTF-8"
	Transport   = &http.Transport{
		Proxy: http.ProxyFromEnvironment,
		DialContext: (&net.Dialer{
			Timeout:   1 * time.Second,
			KeepAlive: 60 * time.Second,
		}).DialContext,
		MaxIdleConns:          100,
		IdleConnTimeout:       90 * time.Second,
		ExpectContinueTimeout: 1 * time.Second,
		ResponseHeaderTimeout: 6 * time.Second,
	}
)

func NewReverseProxy(handler string) *httputil.ReverseProxy {
	director := func(req *http.Request) {
		req.URL.Scheme = UpstreamScheme
		req.URL.Host = UpstreamHost
		req.URL.Path = handler
	}

	return &httputil.ReverseProxy{
		Director:       director,
		Transport:      Transport,
		ErrorHandler:   errorHandler,
		ModifyResponse: modifyResponse,
	}
}

func errorHandler(rw http.ResponseWriter, req *http.Request, err error) {
	simplelog.Error("secret-search request failed", "req", req.URL, "err", err)
	rw.WriteHeader(http.StatusOK)
	rw.Header().Set("Content-Type", ContentType)
	_, err = rw.Write(EmptyResp)
	if err != nil {
		simplelog.Error("failed to write secret-search empty response", "req", req.URL, "err", err)
	}
}

func modifyResponse(rw *http.Response) error {
	switch rw.StatusCode {
	case http.StatusUnauthorized:
		return nil
	case http.StatusOK:
		// ok
		rw.Header.Set("Content-Type", ContentType)
		return nil
	default:
		return fmt.Errorf("not 200 stats code, actual: %d", rw.StatusCode)
	}
}
