package server

import (
	"net/http"
	"strings"

	"github.com/labstack/echo/v4"
)

func (s *Server) knownHandler(c echo.Context) error {
	secret, ok := parseSecret(c)
	if !ok {
		return nil
	}

	known, err := s.db.IsKnown(calcSha1(secret))
	if err != nil {
		return c.JSON(http.StatusInternalServerError, echo.Map{
			"ok":    false,
			"error": err,
		})
	}

	return c.JSON(http.StatusOK, echo.Map{
		"ok":    true,
		"known": known,
	})
}

func (s *Server) touchKnownHandler(c echo.Context) error {
	var input TouchRequest
	if c.Bind(&input) != nil || input.Secret == "" {
		_ = c.JSON(http.StatusBadRequest, echo.Map{
			"ok":    false,
			"error": "no secret",
		})
		return nil
	}

	return c.JSON(http.StatusOK, echo.Map{
		"ok": s.db.TouchKnown(calcSha1(strings.TrimSpace(input.Secret)), input.Meta) == nil,
	})
}
