package server

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/ant-secret/web/internal/searcher"
)

func (s *Server) newSecretSearchHandler(upstreamHandler string) echo.HandlerFunc {
	proxy := searcher.NewReverseProxy(upstreamHandler)
	return func(c echo.Context) error {
		if c.Request().ContentLength <= 0 {
			// OK, nothing to do
			return c.Blob(http.StatusOK, searcher.ContentType, searcher.EmptyResp)
		}

		proxy.ServeHTTP(c.Response(), c.Request())
		return nil
	}
}
